
/**
 * klasse VerlorenVoorwerp
 *
 * @author Goderik Lefebvre
 * @version 2016-06-04
 */
public class Voorwerp
{
    // velden
    private int identificatienummer;
    private String type;
    private String omschrijving;
    private boolean magWeg;
    
    /**
     * Constructor voor objecten van de klasse Voorwerp
     */
    public Voorwerp(int identificatienummer, String type, String omschrijving)
    {
        // velden initialiseren
        this.identificatienummer = identificatienummer;
        this.type= type;
        this.omschrijving = omschrijving;
        magWeg = false;
    }

    /**
     * accessor voor het veld identificatienummer
     * 
     * @return  het identificatienummer van het verloren voorwerp
     */
    public int getIdentificatienummer()
    {
        return identificatienummer;
    }
    
    /**
     * accessor voor het veld type
     * 
     * @return  het type van het verloren voorwerp
     */
    public String getType()
    {
        return type;
    }   
        
    /**
     * accessor voor het veld omschrijving
     * 
     * @return  de omschrijving van het verloren voorwerp
     */    
    public String getOmschrijving()
    {
        return omschrijving;
    }    
    
    /**
     * accessor voor het veld magWeg
     *   dit veld geeft aan of het verloren voorwerp mag meegenomen worden door de kuisploeg (om het te vernietigen)
     * 
     * @return  true als het voorwerp weg mag, anders false
     */   
    public boolean getMagWeg()
    {
       return magWeg;   
    }
        
    /**
     * methode om aan te geven dat het verloren voorwerp definitief weg mag (mag opgehaald worden door de kuisploeg)
     * deze methode zet het veldje magWeg op true
     */ 
    public void zetOpMagWeg()
    {
        magWeg = true;
    }
}
